/*
 * This File is one of the examples from Java For Beginners
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package chapter12;

import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

/**
 * @author Matthew Gregory
 */
public class StartHere {

    public static void main(String[] args) {
        DataSource myInstances = new DataSource();
        Meeting followupMeeting = myInstances.meetings.get("followupMeeting");

        //call the method to make sure it works
//        followupMeeting.processAttendees();

        //Call the method using a lambda expression.
//        followupMeeting.processAttendees((Person p)->{p.printDetails();});

        //Rewriting our sort by birthday example
//        Set<Person> attendees = new TreeSet<>(new CompareByBirthday());
//        attendees.add(followupMeeting.host);
//        System.out.println("Birthday for "+followupMeeting.host.getFullName()
//                +" is "+followupMeeting.host.birthday);
//        followupMeeting.processAttendees(
//                p->{attendees.add(p);System.out.println("Birthday for " +p.getFullName() +" is " +p.birthday);});
//        System.out.println("Attendees: " + attendees);

        //Using a lambda variable
//        Set<Person> attendees = new TreeSet<>(new CompareByBirthday());
//        attendees.add(followupMeeting.host);
//        System.out.println("Birthday for "+followupMeeting.host.getFullName()
//                +" is "+followupMeeting.host.birthday);
//        Consumer<Person> lambda = p->{attendees.add(p);System.out.println("Birthday for " +p.getFullName() +" is " +p.birthday);};
//        followupMeeting.processAttendees(lambda);
//        System.out.println("Attendees: " + attendees);

        //Shortcuts - no datatype needed if it's Person
//        followupMeeting.processAttendees(p->p.printDetails());

        //Using the pre-built method provided with Collections
//        followupMeeting.attendees.forEach(p->p.printDetails());

        
        //Find all the people in my data source born before 1/1/1980
//        LocalDate cutOff = LocalDate.of(1980, 1, 1);
//        Predicate<Person> bornAfter1980 = p -> p.birthday.isAfter(cutOff);
//        myInstances.people.values().removeIf(bornAfter1980);
//        System.out.println("Born Before 1980: ");
//        System.out.println(myInstances.people.values());
//        Consumer<Person> printNameBirthday = 
//                p -> {System.out.println("Name: "+p.getFullName()); System.out.println("Birthday: "+p.birthday);};
//        myInstances.people.values().forEach(printNameBirthday);

        //Make sure that all the agenda items for the initial meeting are upper case.
//        Meeting initialMeeting = myInstances.meetings.get("initialMeeting");
//        initialMeeting.printAgenda();
//        UnaryOperator<String> capitalise = s->s.toUpperCase();
//        initialMeeting.agendaItems.replaceAll(capitalise);
//        initialMeeting.printAgenda();

        //Add the manager to the meeting on the 5th April 2020
        Person manager = new Person("Employee","Patrick","Ewan",LocalDate.of(1967,7,17));
        BiFunction<LocalDate,Meeting,Meeting> remappingFunction=(d/*Current key*/,m/*Current value*/) -> {
            System.out.println("Changing Attendees for meeting on "+d+"!");
            System.out.println("Old Attendees List: "+m.attendees);
            m.attendees.add(manager);
            System.out.println("New Attendees List: "+m.attendees);
            return m;/*New Value*/};
        myInstances.mySchedule.compute(LocalDate.of(2020,4,5), remappingFunction);
        
        //Just to make sure print out the dates and attendees of all meetings on my schedule!
        myInstances.mySchedule.forEach((d,m)->{
            System.out.println("Date: "+d);
            System.out.println("Attendees: "+m.attendees);
        });

    }

}
